//  -*- Mode: C++;  -*-

//  File: gridadd.cpp

//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)

//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// * FUNCTION: adds two grids together

// *

// * RELATED PACKAGES: stabfun.cpp grid.cpp

// *

// * HISTORY:

// * Created:  Mon Oct 18 1999 (dino)

// * Modified: 

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



// the following include file (notice.h) contains important copyright 

// information, as well as other legal statements. it must be present 

// in all files and in any distribution. removal or modification is

// strictly forbidden and violates u.s. and international copyright law.

#include "notice.h"

char *copyright_notice = "(C) 1999 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";

//

#include "stabfun.h"

#include "macros.h"



#define MESSAGES	1



int main (int argc, char **argv) 

{

	int type;



	if (argc != 3)

	{

#if (MESSAGES)

                // invalid arguments, print usage

		cerr << "usage:\n";

		cerr << "\t" << appName(argv) 

		     << " <grid 1> <grid 2> "[<format>]\n";

		cerr << "formats:\n";

		cerr << "\t0 = arcinfo ascii (default)\n";

		cerr << "\t1 = surfer ascii\n";

		cerr << "example:\n";

		cerr << "\t" << appName(argv)

		     << "term1.grd term2.grd > result.grd\n";

#endif

		exit(1);

	}



	if (argc != 4 || (type = atoi(argv[3])) <= 0 || type > 1)

		type = ARCINFO;

	else

		type = SURFER;



	do_GridAdd(argv[1], argv[2], (char *)NULL, type, MESSAGES);



	exit(FALSE);    

	return(TRUE);

}

